# API Jira
Позволяет получать задачи из jira по определенным отборам, изначальный запрос - отбор по постановщику - возможно без проблем.  
В результате запроса по моему прилетает вообще все что есть в задаче, при желании даже с файлами можно работать (пример полного ответа ниже есть), так же можно ограничить поля, которые должны быть в ответе.


Позволяет создавать задачи - тут немножко сложнее, но в целом тоже реализуемо.

## Доступ
Для доступа я использовал токен, который сам для своего пользователя и выпустил, так что логин/пароль остануться в безопасности.  
Понятно что у пользователя под которым будет весь процес работы с задачи происходить должны быть права на работу с задачами.  

----
# Далее техническая информация.

## Примеры
### Пример запроса к Jira
В этом запросе получаю пять задач, созданных "korsunov_k" и назначенных "ageev_a2", возможны простые сортировки доп.отборы и тп благодаря JQL.  
JQL - своего рода упрощенный SQL от atlassian.

``` curl
curl --location 'https://sd.dogma.ru/rest/api/2/search' \
--header 'Content-Type: application/json' \
--header 'Authorization: Bearer MyToken' \
--data '{
    "jql": "assignee = ageev_a2 and creator = korsunov_k",
    "startAt": 0,
    "maxResults": 5,
    "fields": [
        "self",
        "key",
        "summary"
        ]
}'
```
### Пример ответа
``` JSON
{
    "expand": "schema,names",
    "startAt": 0,
    "maxResults": 5,
    "total": 4,
    "issues": [
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "68299",
            "self": "https://sd.dogma.ru/rest/api/2/issue/68299",
            "key": "DEV1C-444",
            "fields": {
                "summary": "Переход коммуникации ДО и ЛК на Rebbit"
            }
        },
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "57268",
            "self": "https://sd.dogma.ru/rest/api/2/issue/57268",
            "key": "DEV1C-350",
            "fields": {
                "summary": "Перевод на новое решение получения ссылок для подключения к сервисам через"
            }
        },
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "56619",
            "self": "https://sd.dogma.ru/rest/api/2/issue/56619",
            "key": "DEV1C-345",
            "fields": {
                "summary": "Аудит интеграций формализация данных"
            }
        },
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "55867",
            "self": "https://sd.dogma.ru/rest/api/2/issue/55867",
            "key": "DEV1C-339",
            "fields": {
                "summary": "Доработка системы применения правил установки паролей"
            }
        }
    ]
}
```
### Полный ответ без ограничения полей
``` JSON
{
    "expand": "schema,names",
    "startAt": 0,
    "maxResults": 5,
    "total": 4,
    "issues": [
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "68299",
            "self": "https://sd.dogma.ru/rest/api/2/issue/68299",
            "key": "DEV1C-444",
            "fields": {
                "customfield_13100": {
                    "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12402",
                    "value": "Большая стройка",
                    "id": "12402",
                    "disabled": false,
                    "child": {
                        "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12408",
                        "value": "Приемка строительных работ, предписания, штрафы",
                        "id": "12408",
                        "disabled": false
                    }
                },
                "fixVersions": [],
                "customfield_10110": null,
                "customfield_10111": null,
                "resolution": null,
                "customfield_10112": null,
                "customfield_10113": null,
                "customfield_10114": null,
                "customfield_10104": null,
                "customfield_10105": null,
                "customfield_10106": null,
                "customfield_10107": null,
                "customfield_10108": null,
                "customfield_10109": null,
                "lastViewed": "2025-07-22T15:18:11.280+0000",
                "priority": {
                    "self": "https://sd.dogma.ru/rest/api/2/priority/3",
                    "iconUrl": "https://sd.dogma.ru/images/icons/priorities/medium.svg",
                    "name": "Средний",
                    "id": "3"
                },
                "customfield_10100": null,
                "customfield_10101": null,
                "customfield_10102": null,
                "labels": [],
                "customfield_10103": null,
                "aggregatetimeoriginalestimate": null,
                "timeestimate": null,
                "versions": [],
                "issuelinks": [],
                "assignee": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=ageev_a2",
                    "name": "ageev_a2",
                    "key": "JIRAUSER25104",
                    "emailAddress": "ageev_a2@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER25104&avatarId=25003",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER25104&avatarId=25003",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER25104&avatarId=25003",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER25104&avatarId=25003"
                    },
                    "displayName": "Агеев Артем Вадимович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "status": {
                    "self": "https://sd.dogma.ru/rest/api/2/status/10005",
                    "description": "В данный момент ведётся активная работа над заявкой ответственным исполнителем.",
                    "iconUrl": "https://sd.dogma.ru/images/icons/status_generic.gif",
                    "name": "▶️В работе",
                    "id": "10005",
                    "statusCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/statuscategory/4",
                        "id": 4,
                        "key": "indeterminate",
                        "colorName": "inprogress",
                        "name": "В работе"
                    }
                },
                "components": [],
                "customfield_10722": null,
                "customfield_10723": null,
                "customfield_10724": null,
                "aggregatetimeestimate": null,
                "customfield_10725": null,
                "customfield_10726": null,
                "customfield_10727": null,
                "customfield_10728": null,
                "creator": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "subtasks": [],
                "reporter": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "customfield_12101": null,
                "customfield_12100": null,
                "aggregateprogress": {
                    "progress": 338400,
                    "total": 338400,
                    "percent": 100
                },
                "customfield_12103": null,
                "customfield_10200": "",
                "customfield_12102": null,
                "customfield_11403": [
                    "Checklist(id=39667, issueId=68299, _items=[])"
                ],
                "customfield_10710": null,
                "customfield_11405": null,
                "customfield_10711": null,
                "customfield_11404": null,
                "customfield_10716": null,
                "customfield_10718": null,
                "progress": {
                    "progress": 338400,
                    "total": 338400,
                    "percent": 100
                },
                "issuetype": {
                    "self": "https://sd.dogma.ru/rest/api/2/issuetype/10005",
                    "id": "10005",
                    "description": "Простая задача, не требующая согласования",
                    "iconUrl": "https://sd.dogma.ru/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype",
                    "name": "Задача",
                    "subtask": false,
                    "avatarId": 10318
                },
                "timespent": 338400,
                "project": {
                    "self": "https://sd.dogma.ru/rest/api/2/project/11700",
                    "id": "11700",
                    "key": "DEV1C",
                    "name": "1С: Разработка по 1С",
                    "projectTypeKey": "software",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/projectavatar?pid=11700&avatarId=19200",
                        "24x24": "https://sd.dogma.ru/secure/projectavatar?size=small&pid=11700&avatarId=19200",
                        "16x16": "https://sd.dogma.ru/secure/projectavatar?size=xsmall&pid=11700&avatarId=19200",
                        "32x32": "https://sd.dogma.ru/secure/projectavatar?size=medium&pid=11700&avatarId=19200"
                    },
                    "projectCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/projectCategory/10001",
                        "id": "10001",
                        "description": "Проекты, связанные с операционной деятельностью",
                        "name": "ОПЕР"
                    }
                },
                "aggregatetimespent": 338400,
                "customfield_12601": null,
                "customfield_10700": "0|i07icv:",
                "customfield_10701": null,
                "resolutiondate": null,
                "customfield_10705": null,
                "customfield_10706": "{summaryBean=com.atlassian.jira.plugin.devstatus.rest.SummaryBean@531d262c[summary={pullrequest=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@4c992ad4[overall=PullRequestOverallBean{stateCount=0, state='OPEN', details=PullRequestOverallDetails{openCount=0, mergedCount=0, declinedCount=0}},byInstanceType={}], build=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@41fd80d8[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BuildOverallBean@4437cdb9[failedBuildCount=0,successfulBuildCount=0,unknownBuildCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], review=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@30a438b4[overall=com.atlassian.jira.plugin.devstatus.summary.beans.ReviewsOverallBean@144566f2[stateCount=0,state=<null>,dueDate=<null>,overDue=false,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], deployment-environment=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@3913dfe2[overall=com.atlassian.jira.plugin.devstatus.summary.beans.DeploymentOverallBean@43b3977c[topEnvironments=[],showProjects=false,successfulCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], repository=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@52c36626[overall=com.atlassian.jira.plugin.devstatus.summary.beans.CommitOverallBean@6d8ee87a[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], branch=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@4a45c6e6[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BranchOverallBean@1592b0a5[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}]},errors=[],configErrors=[]], devSummaryJson={\"cachedValue\":{\"errors\":[],\"configErrors\":[],\"summary\":{\"pullrequest\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":\"OPEN\",\"details\":{\"openCount\":0,\"mergedCount\":0,\"declinedCount\":0,\"total\":0},\"open\":true},\"byInstanceType\":{}},\"build\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"failedBuildCount\":0,\"successfulBuildCount\":0,\"unknownBuildCount\":0},\"byInstanceType\":{}},\"review\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":null,\"dueDate\":null,\"overDue\":false,\"completed\":false},\"byInstanceType\":{}},\"deployment-environment\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"topEnvironments\":[],\"showProjects\":false,\"successfulCount\":0},\"byInstanceType\":{}},\"repository\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}},\"branch\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}}}},\"isStale\":true}}",
                "customfield_10707": null,
                "workratio": -1,
                "customfield_10708": null,
                "customfield_10709": null,
                "watches": {
                    "self": "https://sd.dogma.ru/rest/api/2/issue/DEV1C-444/watchers",
                    "watchCount": 1,
                    "isWatching": false
                },
                "created": "2025-07-01T08:03:19.000+0000",
                "customfield_12200": null,
                "customfield_12600": null,
                "customfield_11105": null,
                "customfield_11106": null,
                "customfield_11107": null,
                "customfield_11900": "2025-07-02",
                "customfield_11901": "2025-11-20",
                "updated": "2025-07-21T14:56:44.000+0000",
                "timeoriginalestimate": null,
                "description": "# Анализ предоставленного реестра вызовов на стороне 1С (предоставила Аня)\r\n # Провести коммуникацию с Савелием\r\n # Получить актуальный реестр точек взаимодействия со всех систем (ЛК и ДО)\r\n # Согласовать концепцию передачи пакетов\r\n # Собрать тестовую среду (ДО и ЛК у Реббита есть тестовая очередь)\r\n # Разработка и моделирование (отрабатываем методику отправки\\ получения и обработки пакета)\r\n # Последовательно переводим в тестовой среде каждый процесс на работу через механизмы, разработанные в 6-м пункте\r\n # Выполнить тестирование с аналитиками (как со стороны 1С так и со стороны WEB)\r\n # Фаза доработки замечаний\r\n # Согласование даты и процессе перехода\r\n # Перевод продуктовой среды на новый механизм\r\n # Мониторинг - сопровождение\r\n\r\n ",
                "customfield_11100": null,
                "customfield_11101": null,
                "customfield_11102": null,
                "customfield_11103": null,
                "customfield_11104": null,
                "summary": "Переход коммуникации ДО и ЛК на Rebbit",
                "customfield_10120": null,
                "customfield_10000": [],
                "customfield_10121": null,
                "customfield_10001": null,
                "customfield_10122": null,
                "customfield_10002": null,
                "customfield_12300": null,
                "customfield_10003": null,
                "customfield_10004": null,
                "customfield_10115": null,
                "customfield_11204": null,
                "customfield_11601": null,
                "customfield_10116": null,
                "customfield_11205": [
                    "1С Документооборот (SOFT-2538)"
                ],
                "environment": null,
                "customfield_10117": null,
                "customfield_10118": null,
                "customfield_10119": null,
                "duedate": null
            }
        },
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "57268",
            "self": "https://sd.dogma.ru/rest/api/2/issue/57268",
            "key": "DEV1C-350",
            "fields": {
                "customfield_13100": {
                    "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12610",
                    "value": "Управление разработкой",
                    "id": "12610",
                    "disabled": false,
                    "child": {
                        "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12611",
                        "value": "DevOps и оптимизация",
                        "id": "12611",
                        "disabled": false
                    }
                },
                "fixVersions": [],
                "customfield_10110": null,
                "customfield_10111": null,
                "resolution": {
                    "self": "https://sd.dogma.ru/rest/api/2/resolution/10000",
                    "id": "10000",
                    "description": "По данному обращению работа завершена.",
                    "name": "Готово"
                },
                "customfield_10112": null,
                "customfield_10113": null,
                "customfield_10114": null,
                "customfield_10104": null,
                "customfield_10105": null,
                "customfield_10106": null,
                "customfield_10107": null,
                "customfield_10108": null,
                "customfield_10109": null,
                "lastViewed": "2025-07-03T15:00:55.341+0000",
                "priority": {
                    "self": "https://sd.dogma.ru/rest/api/2/priority/3",
                    "iconUrl": "https://sd.dogma.ru/images/icons/priorities/medium.svg",
                    "name": "Средний",
                    "id": "3"
                },
                "customfield_10100": null,
                "customfield_10101": null,
                "customfield_10102": null,
                "labels": [],
                "customfield_10103": null,
                "aggregatetimeoriginalestimate": null,
                "timeestimate": null,
                "versions": [],
                "issuelinks": [
                    {
                        "id": "26561",
                        "self": "https://sd.dogma.ru/rest/api/2/issueLink/26561",
                        "type": {
                            "id": "10003",
                            "name": "Связь",
                            "inward": "связана с",
                            "outward": "связана с ",
                            "self": "https://sd.dogma.ru/rest/api/2/issueLinkType/10003"
                        },
                        "outwardIssue": {
                            "id": "46265",
                            "key": "DEV1C-224",
                            "self": "https://sd.dogma.ru/rest/api/2/issue/46265",
                            "fields": {
                                "summary": "Хранение паролей 1С",
                                "status": {
                                    "self": "https://sd.dogma.ru/rest/api/2/status/10005",
                                    "description": "В данный момент ведётся активная работа над заявкой ответственным исполнителем.",
                                    "iconUrl": "https://sd.dogma.ru/images/icons/status_generic.gif",
                                    "name": "▶️В работе",
                                    "id": "10005",
                                    "statusCategory": {
                                        "self": "https://sd.dogma.ru/rest/api/2/statuscategory/4",
                                        "id": 4,
                                        "key": "indeterminate",
                                        "colorName": "inprogress",
                                        "name": "В работе"
                                    }
                                },
                                "priority": {
                                    "self": "https://sd.dogma.ru/rest/api/2/priority/2",
                                    "iconUrl": "https://sd.dogma.ru/images/icons/priorities/high.svg",
                                    "name": "Высокий",
                                    "id": "2"
                                },
                                "issuetype": {
                                    "self": "https://sd.dogma.ru/rest/api/2/issuetype/10005",
                                    "id": "10005",
                                    "description": "Простая задача, не требующая согласования",
                                    "iconUrl": "https://sd.dogma.ru/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype",
                                    "name": "Задача",
                                    "subtask": false,
                                    "avatarId": 10318
                                }
                            }
                        }
                    }
                ],
                "assignee": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=ageev_a2",
                    "name": "ageev_a2",
                    "key": "JIRAUSER25104",
                    "emailAddress": "ageev_a2@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER25104&avatarId=25003",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER25104&avatarId=25003",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER25104&avatarId=25003",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER25104&avatarId=25003"
                    },
                    "displayName": "Агеев Артем Вадимович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "status": {
                    "self": "https://sd.dogma.ru/rest/api/2/status/10004",
                    "description": "Работы над заявкой завершены",
                    "iconUrl": "https://sd.dogma.ru/images/icons/status_generic.gif",
                    "name": "✔️Решено",
                    "id": "10004",
                    "statusCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/statuscategory/3",
                        "id": 3,
                        "key": "done",
                        "colorName": "success",
                        "name": "Выполнено"
                    }
                },
                "components": [],
                "customfield_10722": null,
                "customfield_10723": null,
                "customfield_10724": null,
                "aggregatetimeestimate": null,
                "customfield_10725": null,
                "customfield_10726": null,
                "customfield_10727": null,
                "customfield_10728": null,
                "creator": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "subtasks": [],
                "reporter": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "customfield_12101": null,
                "customfield_12100": null,
                "aggregateprogress": {
                    "progress": 201600,
                    "total": 201600,
                    "percent": 100
                },
                "customfield_12103": null,
                "customfield_10200": "",
                "customfield_12102": null,
                "customfield_11403": [
                    "Checklist(id=30781, issueId=57268, _items=[])"
                ],
                "customfield_10710": null,
                "customfield_11405": "0/0 - Done",
                "customfield_10711": null,
                "customfield_11404": null,
                "customfield_10716": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=tereshkov_p",
                    "name": "tereshkov_p",
                    "key": "JIRAUSER13579",
                    "emailAddress": "tereshkov_p@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER13579&avatarId=14171",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER13579&avatarId=14171",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER13579&avatarId=14171",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER13579&avatarId=14171"
                    },
                    "displayName": "Терешков Павел Евгеньевич",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "customfield_10718": null,
                "progress": {
                    "progress": 201600,
                    "total": 201600,
                    "percent": 100
                },
                "issuetype": {
                    "self": "https://sd.dogma.ru/rest/api/2/issuetype/10005",
                    "id": "10005",
                    "description": "Простая задача, не требующая согласования",
                    "iconUrl": "https://sd.dogma.ru/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype",
                    "name": "Задача",
                    "subtask": false,
                    "avatarId": 10318
                },
                "timespent": 201600,
                "project": {
                    "self": "https://sd.dogma.ru/rest/api/2/project/11700",
                    "id": "11700",
                    "key": "DEV1C",
                    "name": "1С: Разработка по 1С",
                    "projectTypeKey": "software",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/projectavatar?pid=11700&avatarId=19200",
                        "24x24": "https://sd.dogma.ru/secure/projectavatar?size=small&pid=11700&avatarId=19200",
                        "16x16": "https://sd.dogma.ru/secure/projectavatar?size=xsmall&pid=11700&avatarId=19200",
                        "32x32": "https://sd.dogma.ru/secure/projectavatar?size=medium&pid=11700&avatarId=19200"
                    },
                    "projectCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/projectCategory/10001",
                        "id": "10001",
                        "description": "Проекты, связанные с операционной деятельностью",
                        "name": "ОПЕР"
                    }
                },
                "aggregatetimespent": 201600,
                "customfield_13700": 9.50287E8,
                "customfield_12601": null,
                "customfield_10700": "0|i060lb:",
                "customfield_10701": null,
                "resolutiondate": "2025-06-06T10:25:28.000+0000",
                "customfield_10705": null,
                "customfield_10706": "{summaryBean=com.atlassian.jira.plugin.devstatus.rest.SummaryBean@1d9fc9a2[summary={pullrequest=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@5e83d22c[overall=PullRequestOverallBean{stateCount=0, state='OPEN', details=PullRequestOverallDetails{openCount=0, mergedCount=0, declinedCount=0}},byInstanceType={}], build=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@39ae3b[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BuildOverallBean@40eb1ea2[failedBuildCount=0,successfulBuildCount=0,unknownBuildCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], review=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@2cf6c064[overall=com.atlassian.jira.plugin.devstatus.summary.beans.ReviewsOverallBean@a91257a[stateCount=0,state=<null>,dueDate=<null>,overDue=false,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], deployment-environment=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@47941a65[overall=com.atlassian.jira.plugin.devstatus.summary.beans.DeploymentOverallBean@5f92023b[topEnvironments=[],showProjects=false,successfulCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], repository=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@45fd1c4d[overall=com.atlassian.jira.plugin.devstatus.summary.beans.CommitOverallBean@46c44b7d[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], branch=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@216436f2[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BranchOverallBean@6e287b3f[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}]},errors=[],configErrors=[]], devSummaryJson={\"cachedValue\":{\"errors\":[],\"configErrors\":[],\"summary\":{\"pullrequest\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":\"OPEN\",\"details\":{\"openCount\":0,\"mergedCount\":0,\"declinedCount\":0,\"total\":0},\"open\":true},\"byInstanceType\":{}},\"build\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"failedBuildCount\":0,\"successfulBuildCount\":0,\"unknownBuildCount\":0},\"byInstanceType\":{}},\"review\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":null,\"dueDate\":null,\"overDue\":false,\"completed\":false},\"byInstanceType\":{}},\"deployment-environment\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"topEnvironments\":[],\"showProjects\":false,\"successfulCount\":0},\"byInstanceType\":{}},\"repository\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}},\"branch\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}}}},\"isStale\":true}}",
                "customfield_10707": null,
                "workratio": -1,
                "customfield_10708": null,
                "customfield_10709": null,
                "watches": {
                    "self": "https://sd.dogma.ru/rest/api/2/issue/DEV1C-350/watchers",
                    "watchCount": 1,
                    "isWatching": false
                },
                "created": "2025-05-26T10:27:21.000+0000",
                "customfield_12200": null,
                "customfield_12600": null,
                "customfield_11105": null,
                "customfield_11106": null,
                "customfield_11107": null,
                "customfield_11900": "2025-05-29",
                "customfield_11901": "2025-06-20",
                "updated": "2025-06-06T12:03:04.000+0000",
                "timeoriginalestimate": null,
                "description": "Переключение всех интеграций к сервисам http\\https через новое решение во всех информационных базах;\r\n\r\nДаты установил предварительно, пока не обсудим план;\r\n # ЛК в ДО закроем до 03.06\r\n # ЗУПовские ручки до 06.06",
                "customfield_11100": null,
                "customfield_11101": null,
                "customfield_11102": null,
                "customfield_11103": null,
                "customfield_11104": null,
                "summary": "Перевод на новое решение получения ссылок для подключения к сервисам через",
                "customfield_10120": null,
                "customfield_10000": [],
                "customfield_10121": null,
                "customfield_10001": null,
                "customfield_10122": null,
                "customfield_10002": null,
                "customfield_12300": null,
                "customfield_10003": null,
                "customfield_10004": null,
                "customfield_10115": null,
                "customfield_11204": null,
                "customfield_11601": null,
                "customfield_10116": null,
                "customfield_11205": null,
                "environment": null,
                "customfield_10117": null,
                "customfield_10118": null,
                "customfield_10119": null,
                "duedate": null
            }
        },
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "56619",
            "self": "https://sd.dogma.ru/rest/api/2/issue/56619",
            "key": "DEV1C-345",
            "fields": {
                "customfield_13100": {
                    "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12610",
                    "value": "Управление разработкой",
                    "id": "12610",
                    "disabled": false,
                    "child": {
                        "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12611",
                        "value": "DevOps и оптимизация",
                        "id": "12611",
                        "disabled": false
                    }
                },
                "fixVersions": [],
                "customfield_10110": null,
                "customfield_10111": null,
                "resolution": {
                    "self": "https://sd.dogma.ru/rest/api/2/resolution/10000",
                    "id": "10000",
                    "description": "По данному обращению работа завершена.",
                    "name": "Готово"
                },
                "customfield_10112": null,
                "customfield_10113": null,
                "customfield_10114": null,
                "customfield_10104": null,
                "customfield_10105": null,
                "customfield_10106": null,
                "customfield_10107": null,
                "customfield_10108": null,
                "customfield_10109": null,
                "lastViewed": "2025-07-22T08:10:12.473+0000",
                "priority": {
                    "self": "https://sd.dogma.ru/rest/api/2/priority/3",
                    "iconUrl": "https://sd.dogma.ru/images/icons/priorities/medium.svg",
                    "name": "Средний",
                    "id": "3"
                },
                "customfield_10100": null,
                "customfield_10101": null,
                "customfield_10102": null,
                "labels": [],
                "customfield_10103": null,
                "aggregatetimeoriginalestimate": null,
                "timeestimate": null,
                "versions": [],
                "issuelinks": [],
                "assignee": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=ageev_a2",
                    "name": "ageev_a2",
                    "key": "JIRAUSER25104",
                    "emailAddress": "ageev_a2@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER25104&avatarId=25003",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER25104&avatarId=25003",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER25104&avatarId=25003",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER25104&avatarId=25003"
                    },
                    "displayName": "Агеев Артем Вадимович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "status": {
                    "self": "https://sd.dogma.ru/rest/api/2/status/10004",
                    "description": "Работы над заявкой завершены",
                    "iconUrl": "https://sd.dogma.ru/images/icons/status_generic.gif",
                    "name": "✔️Решено",
                    "id": "10004",
                    "statusCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/statuscategory/3",
                        "id": 3,
                        "key": "done",
                        "colorName": "success",
                        "name": "Выполнено"
                    }
                },
                "components": [],
                "customfield_10722": null,
                "customfield_10723": null,
                "customfield_10724": null,
                "aggregatetimeestimate": null,
                "customfield_10725": null,
                "customfield_10726": null,
                "customfield_10727": null,
                "customfield_10728": null,
                "creator": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "subtasks": [],
                "reporter": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "customfield_12101": null,
                "customfield_12100": null,
                "aggregateprogress": {
                    "progress": 230400,
                    "total": 230400,
                    "percent": 100
                },
                "customfield_12103": null,
                "customfield_10200": "",
                "customfield_12102": null,
                "customfield_11403": [
                    "Checklist(id=30297, issueId=56619, _items=[])"
                ],
                "customfield_10710": null,
                "customfield_11405": null,
                "customfield_10711": null,
                "customfield_11404": null,
                "customfield_10716": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "customfield_10718": null,
                "progress": {
                    "progress": 230400,
                    "total": 230400,
                    "percent": 100
                },
                "issuetype": {
                    "self": "https://sd.dogma.ru/rest/api/2/issuetype/10005",
                    "id": "10005",
                    "description": "Простая задача, не требующая согласования",
                    "iconUrl": "https://sd.dogma.ru/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype",
                    "name": "Задача",
                    "subtask": false,
                    "avatarId": 10318
                },
                "timespent": 230400,
                "project": {
                    "self": "https://sd.dogma.ru/rest/api/2/project/11700",
                    "id": "11700",
                    "key": "DEV1C",
                    "name": "1С: Разработка по 1С",
                    "projectTypeKey": "software",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/projectavatar?pid=11700&avatarId=19200",
                        "24x24": "https://sd.dogma.ru/secure/projectavatar?size=small&pid=11700&avatarId=19200",
                        "16x16": "https://sd.dogma.ru/secure/projectavatar?size=xsmall&pid=11700&avatarId=19200",
                        "32x32": "https://sd.dogma.ru/secure/projectavatar?size=medium&pid=11700&avatarId=19200"
                    },
                    "projectCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/projectCategory/10001",
                        "id": "10001",
                        "description": "Проекты, связанные с операционной деятельностью",
                        "name": "ОПЕР"
                    }
                },
                "aggregatetimespent": 230400,
                "customfield_13700": 1.049104E9,
                "customfield_12601": null,
                "customfield_10700": "0|i05xpz:",
                "customfield_10701": null,
                "resolutiondate": "2025-06-04T09:32:12.000+0000",
                "customfield_10705": null,
                "customfield_10706": "{summaryBean=com.atlassian.jira.plugin.devstatus.rest.SummaryBean@61170a56[summary={pullrequest=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@550b6972[overall=PullRequestOverallBean{stateCount=0, state='OPEN', details=PullRequestOverallDetails{openCount=0, mergedCount=0, declinedCount=0}},byInstanceType={}], build=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@5fa027ff[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BuildOverallBean@516e9580[failedBuildCount=0,successfulBuildCount=0,unknownBuildCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], review=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@427f7004[overall=com.atlassian.jira.plugin.devstatus.summary.beans.ReviewsOverallBean@22e5ea77[stateCount=0,state=<null>,dueDate=<null>,overDue=false,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], deployment-environment=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@7c24ae0b[overall=com.atlassian.jira.plugin.devstatus.summary.beans.DeploymentOverallBean@5943f69a[topEnvironments=[],showProjects=false,successfulCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], repository=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@608542e6[overall=com.atlassian.jira.plugin.devstatus.summary.beans.CommitOverallBean@6d3ebad3[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], branch=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@34330589[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BranchOverallBean@7202c2b3[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}]},errors=[],configErrors=[]], devSummaryJson={\"cachedValue\":{\"errors\":[],\"configErrors\":[],\"summary\":{\"pullrequest\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":\"OPEN\",\"details\":{\"openCount\":0,\"mergedCount\":0,\"declinedCount\":0,\"total\":0},\"open\":true},\"byInstanceType\":{}},\"build\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"failedBuildCount\":0,\"successfulBuildCount\":0,\"unknownBuildCount\":0},\"byInstanceType\":{}},\"review\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":null,\"dueDate\":null,\"overDue\":false,\"completed\":false},\"byInstanceType\":{}},\"deployment-environment\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"topEnvironments\":[],\"showProjects\":false,\"successfulCount\":0},\"byInstanceType\":{}},\"repository\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}},\"branch\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}}}},\"isStale\":true}}",
                "customfield_10707": null,
                "workratio": -1,
                "customfield_10708": null,
                "customfield_10709": null,
                "watches": {
                    "self": "https://sd.dogma.ru/rest/api/2/issue/DEV1C-345/watchers",
                    "watchCount": 1,
                    "isWatching": false
                },
                "created": "2025-05-23T06:07:08.000+0000",
                "customfield_12200": null,
                "customfield_12600": null,
                "customfield_11105": null,
                "customfield_11106": null,
                "customfield_11107": null,
                "customfield_11900": "2025-05-19",
                "customfield_11901": "2025-05-30",
                "updated": "2025-06-04T09:32:12.000+0000",
                "timeoriginalestimate": null,
                "description": "* Изучить справочный материал\r\n * Провести общий аудит по интеграциям\r\n * Формализовать данные в Confluence\r\n\r\nКонечный результат: примеры описания обменов для того чтобы в начале проекта по Датареону обсудить\\предложить коллегам;",
                "customfield_11100": null,
                "customfield_11101": null,
                "customfield_11102": null,
                "customfield_11103": null,
                "customfield_11104": null,
                "summary": "Аудит интеграций формализация данных",
                "customfield_10120": null,
                "customfield_10000": [],
                "customfield_10121": null,
                "customfield_10001": null,
                "customfield_10122": null,
                "customfield_10002": null,
                "customfield_12300": null,
                "customfield_10003": null,
                "customfield_10004": null,
                "customfield_10115": null,
                "customfield_11204": null,
                "customfield_11601": null,
                "customfield_10116": null,
                "customfield_11205": null,
                "environment": null,
                "customfield_10117": null,
                "customfield_10118": null,
                "customfield_10119": null,
                "duedate": null
            }
        },
        {
            "expand": "operations,versionedRepresentations,editmeta,changelog,renderedFields",
            "id": "55867",
            "self": "https://sd.dogma.ru/rest/api/2/issue/55867",
            "key": "DEV1C-339",
            "fields": {
                "customfield_13100": {
                    "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12610",
                    "value": "Управление разработкой",
                    "id": "12610",
                    "disabled": false,
                    "child": {
                        "self": "https://sd.dogma.ru/rest/api/2/customFieldOption/12611",
                        "value": "DevOps и оптимизация",
                        "id": "12611",
                        "disabled": false
                    }
                },
                "fixVersions": [],
                "customfield_10110": null,
                "customfield_10111": null,
                "resolution": null,
                "customfield_10112": null,
                "customfield_10113": null,
                "customfield_10114": null,
                "customfield_10104": null,
                "customfield_10105": null,
                "customfield_10106": null,
                "customfield_10107": null,
                "customfield_10108": null,
                "customfield_10109": null,
                "lastViewed": "2025-07-23T11:03:14.988+0000",
                "priority": {
                    "self": "https://sd.dogma.ru/rest/api/2/priority/3",
                    "iconUrl": "https://sd.dogma.ru/images/icons/priorities/medium.svg",
                    "name": "Средний",
                    "id": "3"
                },
                "customfield_10100": null,
                "customfield_10101": null,
                "customfield_10102": null,
                "labels": [],
                "customfield_10103": null,
                "aggregatetimeoriginalestimate": null,
                "timeestimate": null,
                "versions": [],
                "issuelinks": [],
                "assignee": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=ageev_a2",
                    "name": "ageev_a2",
                    "key": "JIRAUSER25104",
                    "emailAddress": "ageev_a2@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER25104&avatarId=25003",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER25104&avatarId=25003",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER25104&avatarId=25003",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER25104&avatarId=25003"
                    },
                    "displayName": "Агеев Артем Вадимович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "status": {
                    "self": "https://sd.dogma.ru/rest/api/2/status/10601",
                    "description": "Тестирование нового функционала системы",
                    "iconUrl": "https://sd.dogma.ru/images/icons/statuses/generic.png",
                    "name": "⚙️Тестирование",
                    "id": "10601",
                    "statusCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/statuscategory/4",
                        "id": 4,
                        "key": "indeterminate",
                        "colorName": "inprogress",
                        "name": "В работе"
                    }
                },
                "components": [],
                "customfield_10722": null,
                "customfield_10723": null,
                "customfield_10724": null,
                "aggregatetimeestimate": null,
                "customfield_10725": null,
                "customfield_10726": null,
                "customfield_10727": null,
                "customfield_10728": null,
                "creator": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "subtasks": [],
                "reporter": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=korsunov_k",
                    "name": "korsunov_k",
                    "key": "JIRAUSER16101",
                    "emailAddress": "korsunov_k@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER16101&avatarId=15103",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER16101&avatarId=15103",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER16101&avatarId=15103",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER16101&avatarId=15103"
                    },
                    "displayName": "Корсунов Константин Александрович",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "customfield_12101": null,
                "customfield_12100": null,
                "aggregateprogress": {
                    "progress": 126000,
                    "total": 126000,
                    "percent": 100
                },
                "customfield_12103": null,
                "customfield_10200": "",
                "customfield_12102": null,
                "customfield_11403": [
                    "Checklist(id=29619, issueId=55867, _items=[])"
                ],
                "customfield_10710": null,
                "customfield_11405": null,
                "customfield_10711": null,
                "customfield_11404": null,
                "customfield_10716": {
                    "self": "https://sd.dogma.ru/rest/api/2/user?username=napolskikh",
                    "name": "napolskikh",
                    "key": "JIRAUSER10392",
                    "emailAddress": "napolskikh@dogma.ru",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/useravatar?ownerId=JIRAUSER10392&avatarId=11932",
                        "24x24": "https://sd.dogma.ru/secure/useravatar?size=small&ownerId=JIRAUSER10392&avatarId=11932",
                        "16x16": "https://sd.dogma.ru/secure/useravatar?size=xsmall&ownerId=JIRAUSER10392&avatarId=11932",
                        "32x32": "https://sd.dogma.ru/secure/useravatar?size=medium&ownerId=JIRAUSER10392&avatarId=11932"
                    },
                    "displayName": "Напольских Юлия Владимировна",
                    "active": true,
                    "timeZone": "Etc/GMT-3"
                },
                "customfield_10718": null,
                "progress": {
                    "progress": 126000,
                    "total": 126000,
                    "percent": 100
                },
                "issuetype": {
                    "self": "https://sd.dogma.ru/rest/api/2/issuetype/10005",
                    "id": "10005",
                    "description": "Простая задача, не требующая согласования",
                    "iconUrl": "https://sd.dogma.ru/secure/viewavatar?size=xsmall&avatarId=10318&avatarType=issuetype",
                    "name": "Задача",
                    "subtask": false,
                    "avatarId": 10318
                },
                "timespent": 126000,
                "project": {
                    "self": "https://sd.dogma.ru/rest/api/2/project/11700",
                    "id": "11700",
                    "key": "DEV1C",
                    "name": "1С: Разработка по 1С",
                    "projectTypeKey": "software",
                    "avatarUrls": {
                        "48x48": "https://sd.dogma.ru/secure/projectavatar?pid=11700&avatarId=19200",
                        "24x24": "https://sd.dogma.ru/secure/projectavatar?size=small&pid=11700&avatarId=19200",
                        "16x16": "https://sd.dogma.ru/secure/projectavatar?size=xsmall&pid=11700&avatarId=19200",
                        "32x32": "https://sd.dogma.ru/secure/projectavatar?size=medium&pid=11700&avatarId=19200"
                    },
                    "projectCategory": {
                        "self": "https://sd.dogma.ru/rest/api/2/projectCategory/10001",
                        "id": "10001",
                        "description": "Проекты, связанные с операционной деятельностью",
                        "name": "ОПЕР"
                    }
                },
                "aggregatetimespent": 126000,
                "customfield_12601": null,
                "customfield_10700": "0|i05tlz:",
                "customfield_10701": null,
                "resolutiondate": null,
                "customfield_10705": null,
                "customfield_10706": "{summaryBean=com.atlassian.jira.plugin.devstatus.rest.SummaryBean@493bf33f[summary={pullrequest=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@186c0742[overall=PullRequestOverallBean{stateCount=0, state='OPEN', details=PullRequestOverallDetails{openCount=0, mergedCount=0, declinedCount=0}},byInstanceType={}], build=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@7f312be5[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BuildOverallBean@79f7556[failedBuildCount=0,successfulBuildCount=0,unknownBuildCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], review=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@3b9cb2f1[overall=com.atlassian.jira.plugin.devstatus.summary.beans.ReviewsOverallBean@7ea3c874[stateCount=0,state=<null>,dueDate=<null>,overDue=false,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], deployment-environment=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@8bbaa46[overall=com.atlassian.jira.plugin.devstatus.summary.beans.DeploymentOverallBean@74725bc2[topEnvironments=[],showProjects=false,successfulCount=0,count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], repository=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@2aa77487[overall=com.atlassian.jira.plugin.devstatus.summary.beans.CommitOverallBean@4a27f9cf[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}], branch=com.atlassian.jira.plugin.devstatus.rest.SummaryItemBean@1f1b8357[overall=com.atlassian.jira.plugin.devstatus.summary.beans.BranchOverallBean@79d1773d[count=0,lastUpdated=<null>,lastUpdatedTimestamp=<null>],byInstanceType={}]},errors=[],configErrors=[]], devSummaryJson={\"cachedValue\":{\"errors\":[],\"configErrors\":[],\"summary\":{\"pullrequest\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":\"OPEN\",\"details\":{\"openCount\":0,\"mergedCount\":0,\"declinedCount\":0,\"total\":0},\"open\":true},\"byInstanceType\":{}},\"build\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"failedBuildCount\":0,\"successfulBuildCount\":0,\"unknownBuildCount\":0},\"byInstanceType\":{}},\"review\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"stateCount\":0,\"state\":null,\"dueDate\":null,\"overDue\":false,\"completed\":false},\"byInstanceType\":{}},\"deployment-environment\":{\"overall\":{\"count\":0,\"lastUpdated\":null,\"topEnvironments\":[],\"showProjects\":false,\"successfulCount\":0},\"byInstanceType\":{}},\"repository\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}},\"branch\":{\"overall\":{\"count\":0,\"lastUpdated\":null},\"byInstanceType\":{}}}},\"isStale\":false}}",
                "customfield_10707": null,
                "workratio": -1,
                "customfield_10708": null,
                "customfield_10709": null,
                "watches": {
                    "self": "https://sd.dogma.ru/rest/api/2/issue/DEV1C-339/watchers",
                    "watchCount": 5,
                    "isWatching": true
                },
                "created": "2025-05-20T15:52:14.000+0000",
                "customfield_12200": null,
                "customfield_12600": null,
                "customfield_11105": null,
                "customfield_11106": null,
                "customfield_11107": null,
                "customfield_11900": "2025-05-28",
                "customfield_11901": "2025-05-30",
                "updated": "2025-07-23T09:15:15.000+0000",
                "timeoriginalestimate": null,
                "description": "В 1С базах некоторые пользователи (служебные), для не должна действовать политика автоматической или принудительной смены пароля.\r\n * Исключить служебных пользователей из регламентной смены пароль\r\n\r\nДля служебных пользователей:\r\n * Можно ли сделать отдельные настройки входа для обычных пользователей и для служебных\r\n\r\nДля справки:\r\n * [https://infostart.ru/1c/tools/169917/]\r\n * [https://infostart.ru/1c/tools/2233223/]\r\n * [https://infostart.ru/1c/tools/2352908/]",
                "customfield_11100": null,
                "customfield_11101": null,
                "customfield_11102": null,
                "customfield_11103": null,
                "customfield_11104": null,
                "summary": "Доработка системы применения правил установки паролей",
                "customfield_10120": null,
                "customfield_10000": [],
                "customfield_10121": null,
                "customfield_10001": null,
                "customfield_10122": null,
                "customfield_10002": null,
                "customfield_12300": null,
                "customfield_10003": null,
                "customfield_10004": null,
                "customfield_10115": null,
                "customfield_11204": null,
                "customfield_11601": null,
                "customfield_10116": null,
                "customfield_11205": null,
                "environment": null,
                "customfield_10117": null,
                "customfield_10118": null,
                "customfield_10119": null,
                "duedate": null
            }
        }
    ]
}
```

## Полезные ссылки
- [Наша версия - основное](https://docs.atlassian.com/software/jira/docs/api/REST/9.12.0/#api/2/search-searchUsingSearchRequest)  
- [Расширенное описание](https://developer.atlassian.com/cloud/jira/platform/rest/v2/api-group-issue-search/#api-group-issue-search)  
- [Авторизация](https://developer.atlassian.com/cloud/jira/platform/basic-auth-for-rest-apis/)  
- [JQL (официальная дока)](https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/)
- [JQL (хабр)](https://habr.com/ru/companies/raiffeisenbank/articles/449932/)
